<?php
if ( ! function_exists('custom_post_type_slide_show') ) {
function custom_post_type_slide_show() {
	$labels = array(
		'name'                => _x( 'اسلاید شو', 'Post Type General Name' ),
		'singular_name'       => _x( 'اسلاید شو', 'Post Type Singular Name' ),
		'menu_name'           => __( 'اسلاید شو' ),
		'name_admin_bar'      => __( 'اسلاید شو ها' ),
		'parent_item_colon'   => __( 'Parent Item:' ),
		'all_items'           => __( 'همه اسلاید شو ها' ),
		'add_new_item'        => __( 'اضافه کردن اسلاید شو جدید' ),
		'add_new'             => __( 'افزودن اسلاید شو' ),
		'new_item'            => __( 'اسلاید شو جدید' ),
		'edit_item'           => __( 'ویرایش اسلاید شو' ),
		'update_item'         => __( 'بروزرسانی اسلاید شو' ),
		'view_item'           => __( 'مشاهده اسلاید شو' ),
		'search_items'        => __( 'جستجو' ),
		'not_found'           => __( 'پیدا نشد' ),
		'not_found_in_trash'  => __( 'هیچ موردی پیدا نشد' ),
	);
	$args = array(
		'label'               => __( 'اسلاید شو' ),
		'description'         => __( 'اسلاید شو های ارسالی کاربران' ),
		'labels'              => $labels,
		'supports'            => array( 'title' ),
		'hierarchical'        => false,
		'public'              => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'menu_position'       => 5,
		'show_in_admin_bar'   => true,
		'show_in_nav_menus'   => true,
		'can_export'          => true,
		'has_archive'         => 'slide_show',
		'exclude_from_search' => false,
		'publicly_queryable'  => true,
		'capability_type'     => 'page',
	);
	register_post_type( 'slide_show', $args );
}
add_action( 'init', 'custom_post_type_slide_show', 0 );
}

if ( ! function_exists('custom_post_type_my_comments') ) {
function custom_post_type_my_comments() {
	$labels = array(
		'name'                => _x( 'نظرات کاربران', 'Post Type General Name' ),
		'singular_name'       => _x( 'نظرات کاربران', 'Post Type Singular Name' ),
		'menu_name'           => __( 'نظرات کاربران' ),
		'name_admin_bar'      => __( 'نظرات کاربران ها' ),
		'parent_item_colon'   => __( 'Parent Item:' ),
		'all_items'           => __( 'همه نظرات کاربران ها' ),
		'add_new_item'        => __( 'اضافه کردن نظرات کاربران جدید' ),
		'add_new'             => __( 'افزودن نظرات کاربران' ),
		'new_item'            => __( 'نظرات کاربران جدید' ),
		'edit_item'           => __( 'ویرایش نظرات کاربران' ),
		'update_item'         => __( 'بروزرسانی نظرات کاربران' ),
		'view_item'           => __( 'مشاهده نظرات کاربران' ),
		'search_items'        => __( 'جستجو' ),
		'not_found'           => __( 'پیدا نشد' ),
		'not_found_in_trash'  => __( 'هیچ موردی پیدا نشد' ),
	);
	$args = array(
		'label'               => __( 'نظرات کاربران' ),
		'description'         => __( 'نظرات کاربران های ارسالی کاربران' ),
		'labels'              => $labels,
		'supports'            => array( 'title' ),
		'hierarchical'        => false,
		'public'              => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'menu_position'       => 5,
		'show_in_admin_bar'   => true,
		'show_in_nav_menus'   => true,
		'can_export'          => true,
		'has_archive'         => 'my_comments',
		'exclude_from_search' => false,
		'publicly_queryable'  => true,
		'capability_type'     => 'page',
	);
	register_post_type( 'my_comments', $args );
}
add_action( 'init', 'custom_post_type_my_comments', 0 );
}
?>